/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request.websockets;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.RequestService$EventHandler;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService$RequestProcessor;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;
import pro.gravit.launcher.oeUl5HjAXywz;
import pro.gravit.utils.helper.LogHelper;

public class OfflineRequestService
implements RequestService {
    private final HashSet<RequestService$EventHandler> eventHandlers = new HashSet();
    private final Map<Class<?>, OfflineRequestService$RequestProcessor<?, ?>> processors = new ConcurrentHashMap();

    @Override
    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) {
        OfflineRequestService$RequestProcessor<?, ?> offlineRequestService$RequestProcessor = this.processors.get(request.getClass());
        CompletableFuture completableFuture = new CompletableFuture();
        if (offlineRequestService$RequestProcessor == null) {
            completableFuture.completeExceptionally(new RequestException(String.format("Offline mode not support '%s'", request.getType())));
            return completableFuture;
        }
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev("Request %s: %s", request.getType(), oeUl5HjAXywz.oeriE0RRqYNu.Oe9hIhbqOVs7.toJson(request));
        }
        try {
            Object obj = offlineRequestService$RequestProcessor.process(request);
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev("Response %s: %s", obj.getType(), oeUl5HjAXywz.oeriE0RRqYNu.Oe9hIhbqOVs7.toJson(obj));
            }
            completableFuture.complete(obj);
        }
        catch (Throwable throwable) {
            if (throwable instanceof RequestException) {
                completableFuture.completeExceptionally(throwable);
            }
            completableFuture.completeExceptionally(new RequestException(throwable));
        }
        return completableFuture;
    }

    @Override
    public void connect() {
    }

    @Override
    public void registerEventHandler(RequestService$EventHandler requestService$EventHandler) {
        this.eventHandlers.add(requestService$EventHandler);
    }

    @Override
    public void unregisterEventHandler(RequestService$EventHandler requestService$EventHandler) {
        this.eventHandlers.remove(requestService$EventHandler);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public <T extends WebSocketEvent, V extends WebSocketRequest> void registerRequestProcessor(Class<V> clazz, OfflineRequestService$RequestProcessor<T, V> offlineRequestService$RequestProcessor) {
        this.processors.put(clazz, offlineRequestService$RequestProcessor);
    }

    public <T extends WebSocketEvent> void unregisterRequestProcessor(Class<Request<T>> clazz) {
        this.processors.remove(clazz);
    }
}

