/*
 * Decompiled with CFR 0.152.
 */
package oshi.driver.windows.perfmon;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.windows.perfmon.ProcessInformation;
import oshi.driver.windows.perfmon.SystemInformation;
import oshi.util.tuples.Pair;

@ThreadSafe
public final class LoadAverage {
    private static Thread loadAvgThread = null;
    private static double[] loadAverages = new double[]{-1.0, -1.0, -1.0};
    private static final double[] EXP_WEIGHT = new double[]{Math.exp(-0.08333333333333333), Math.exp(-0.016666666666666666), Math.exp(-0.005555555555555556)};

    private LoadAverage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] queryLoadAverage(int n) {
        double[] dArray = loadAverages;
        synchronized (loadAverages) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Arrays.copyOf(loadAverages, n);
        }
    }

    public static synchronized void stopDaemon() {
        if (loadAvgThread != null) {
            loadAvgThread.interrupt();
            loadAvgThread = null;
        }
    }

    public static synchronized void startDaemon() {
        if (loadAvgThread != null) {
            return;
        }
        loadAvgThread = new Thread("OSHI Load Average daemon"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Pair pair = LoadAverage.queryNonIdleTicks();
                long l = (Long)pair.getA();
                long l2 = (Long)pair.getB();
                long l3 = System.nanoTime();
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                while (!Thread.currentThread().isInterrupted()) {
                    pair = LoadAverage.queryNonIdleTicks();
                    long l4 = (Long)pair.getA() - l;
                    long l5 = (Long)pair.getB() - l2;
                    double d = l5 > 0L && l4 > 0L ? (double)l4 / (double)l5 : 0.0;
                    l = (Long)pair.getA();
                    l2 = (Long)pair.getB();
                    long l6 = SystemInformation.queryProcessorQueueLength().getOrDefault(SystemInformation.ProcessorQueueLengthProperty.PROCESSORQUEUELENGTH, 0L);
                    double[] dArray = loadAverages;
                    synchronized (dArray) {
                        if (loadAverages[0] < 0.0) {
                            Arrays.fill(loadAverages, d);
                        }
                        for (int i = 0; i < loadAverages.length; ++i) {
                            double[] dArray2 = loadAverages;
                            int n = i;
                            dArray2[n] = dArray2[n] * EXP_WEIGHT[i];
                            double[] dArray3 = loadAverages;
                            int n2 = i;
                            dArray3[n2] = dArray3[n2] + (d + (double)l6) * (1.0 - EXP_WEIGHT[i]);
                        }
                    }
                    long l7 = 5000L - (System.nanoTime() - l3) % 5000000000L / 1000000L;
                    if (l7 < 500L) {
                        l7 += 5000L;
                    }
                    try {
                        Thread.sleep(l7);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
        loadAvgThread.setDaemon(true);
        loadAvgThread.start();
    }

    private static Pair<Long, Long> queryNonIdleTicks() {
        Pair<List<String>, Map<ProcessInformation.IdleProcessorTimeProperty, List<Long>>> pair = ProcessInformation.queryIdleProcessCounters();
        List<String> list = pair.getA();
        Map<ProcessInformation.IdleProcessorTimeProperty, List<Long>> map = pair.getB();
        List<Long> list2 = map.get(ProcessInformation.IdleProcessorTimeProperty.PERCENTPROCESSORTIME);
        List<Long> list3 = map.get(ProcessInformation.IdleProcessorTimeProperty.ELAPSEDTIME);
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < list.size(); ++i) {
            if ("_Total".equals(list.get(i))) {
                l += list2.get(i).longValue();
                l2 += list3.get(i).longValue();
                continue;
            }
            if (!"Idle".equals(list.get(i))) continue;
            l -= list2.get(i).longValue();
        }
        return new Pair<Long, Long>(l, l2);
    }
}

