/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.util.ArrayList;
import java.util.Map;

final class MapTypeAdapterFactory$Adapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private final TypeAdapter<K> keyTypeAdapter;
    private final TypeAdapter<V> valueTypeAdapter;
    private final ObjectConstructor<? extends Map<K, V>> constructor;
    final /* synthetic */ MapTypeAdapterFactory this$0;

    public MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, TypeAdapter<K> typeAdapter, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
        this.this$0 = mapTypeAdapterFactory;
        this.keyTypeAdapter = typeAdapter;
        this.valueTypeAdapter = typeAdapter2;
        this.constructor = objectConstructor;
    }

    @Override
    public Map<K, V> read(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Map<K, V> map = this.constructor.construct();
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                K k = this.keyTypeAdapter.read(jsonReader);
                V v = this.valueTypeAdapter.read(jsonReader);
                V v2 = map.put(k, v);
                if (v2 != null) {
                    throw new JsonSyntaxException("duplicate key: " + k);
                }
                jsonReader.endArray();
            }
            jsonReader.endArray();
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                V v;
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                K k = this.keyTypeAdapter.read(jsonReader);
                V v3 = map.put(k, v = this.valueTypeAdapter.read(jsonReader));
                if (v3 == null) continue;
                throw new JsonSyntaxException("duplicate key: " + k);
            }
            jsonReader.endObject();
        }
        return map;
    }

    @Override
    public void write(JsonWriter jsonWriter, Map<K, V> map) {
        JsonElement jsonElement;
        if (map == null) {
            jsonWriter.nullValue();
            return;
        }
        if (!this.this$0.complexMapKeySerialization) {
            jsonWriter.beginObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                jsonWriter.name(String.valueOf(entry.getKey()));
                this.valueTypeAdapter.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        boolean bl = false;
        ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(map.size());
        ArrayList<V> arrayList2 = new ArrayList<V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            jsonElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
            arrayList.add(jsonElement);
            arrayList2.add(entry.getValue());
            bl |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
        }
        if (bl) {
            jsonWriter.beginArray();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                jsonWriter.beginArray();
                Streams.write((JsonElement)arrayList.get(i), jsonWriter);
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i));
                jsonWriter.endArray();
            }
            jsonWriter.endArray();
        } else {
            jsonWriter.beginObject();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                jsonElement = (JsonElement)arrayList.get(i);
                jsonWriter.name(this.keyToString(jsonElement));
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i));
            }
            jsonWriter.endObject();
        }
    }

    private String keyToString(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return String.valueOf(jsonPrimitive.getAsNumber());
            }
            if (jsonPrimitive.isBoolean()) {
                return Boolean.toString(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            throw new AssertionError();
        }
        if (jsonElement.isJsonNull()) {
            return "null";
        }
        throw new AssertionError();
    }
}

