/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.GsonPreconditions;
import com.google.gson.internal.GsonTypes$GenericArrayTypeImpl;
import com.google.gson.internal.GsonTypes$ParameterizedTypeImpl;
import com.google.gson.internal.GsonTypes$WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;

public final class GsonTypes {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private GsonTypes() {
        throw new UnsupportedOperationException();
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type type, Class<?> clazz, Type ... typeArray) {
        return new GsonTypes$ParameterizedTypeImpl(type, clazz, typeArray);
    }

    public static GenericArrayType arrayOf(Type type) {
        return new GsonTypes$GenericArrayTypeImpl(type);
    }

    public static WildcardType subtypeOf(Type type) {
        Type[] typeArray = type instanceof WildcardType ? ((WildcardType)type).getUpperBounds() : new Type[]{type};
        return new GsonTypes$WildcardTypeImpl(typeArray, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type type) {
        Type[] typeArray = type instanceof WildcardType ? ((WildcardType)type).getLowerBounds() : new Type[]{type};
        return new GsonTypes$WildcardTypeImpl(new Type[]{Object.class}, typeArray);
    }

    public static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? new GsonTypes$GenericArrayTypeImpl(GsonTypes.canonicalize(clazz.getComponentType())) : clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return new GsonTypes$ParameterizedTypeImpl(parameterizedType.getOwnerType(), (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return new GsonTypes$GenericArrayTypeImpl(genericArrayType.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new GsonTypes$WildcardTypeImpl(wildcardType.getUpperBounds(), wildcardType.getLowerBounds());
        }
        return type;
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            GsonPreconditions.checkArgument(type2 instanceof Class);
            return (Class)type2;
        }
        if (type instanceof GenericArrayType) {
            Type type3 = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(GsonTypes.getRawType(type3), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            assert (typeArray.length == 1);
            return GsonTypes.getRawType(typeArray[0]);
        }
        String string = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + string);
    }

    private static boolean equal(Object object, Object object2) {
        return Objects.equals(object, object2);
    }

    public static boolean equals(Type type, Type type2) {
        if (type == type2) {
            return true;
        }
        if (type instanceof Class) {
            return type.equals(type2);
        }
        if (type instanceof ParameterizedType) {
            if (!(type2 instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ParameterizedType parameterizedType2 = (ParameterizedType)type2;
            return GsonTypes.equal(parameterizedType.getOwnerType(), parameterizedType2.getOwnerType()) && parameterizedType.getRawType().equals(parameterizedType2.getRawType()) && Arrays.equals(parameterizedType.getActualTypeArguments(), parameterizedType2.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            if (!(type2 instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType genericArrayType = (GenericArrayType)type;
            GenericArrayType genericArrayType2 = (GenericArrayType)type2;
            return GsonTypes.equals(genericArrayType.getGenericComponentType(), genericArrayType2.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (!(type2 instanceof WildcardType)) {
                return false;
            }
            WildcardType wildcardType = (WildcardType)type;
            WildcardType wildcardType2 = (WildcardType)type2;
            return Arrays.equals(wildcardType.getUpperBounds(), wildcardType2.getUpperBounds()) && Arrays.equals(wildcardType.getLowerBounds(), wildcardType2.getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            if (!(type2 instanceof TypeVariable)) {
                return false;
            }
            TypeVariable typeVariable = (TypeVariable)type;
            TypeVariable typeVariable2 = (TypeVariable)type2;
            return Objects.equals(typeVariable.getGenericDeclaration(), typeVariable2.getGenericDeclaration()) && typeVariable.getName().equals(typeVariable2.getName());
        }
        return false;
    }

    public static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    private static Type getGenericSupertype(Type type, Class<?> object, Class<?> clazz) {
        Object object2;
        if (clazz == object) {
            return type;
        }
        if (clazz.isInterface()) {
            object2 = ((Class)object).getInterfaces();
            int n = ((Class<?>[])object2).length;
            for (int i = 0; i < n; ++i) {
                if (object2[i] == clazz) {
                    return ((Class)object).getGenericInterfaces()[i];
                }
                if (!clazz.isAssignableFrom(object2[i])) continue;
                return GsonTypes.getGenericSupertype(((Class)object).getGenericInterfaces()[i], object2[i], clazz);
            }
        }
        if (!((Class)object).isInterface()) {
            while (object != Object.class) {
                object2 = ((Class)object).getSuperclass();
                if (object2 == clazz) {
                    return ((Class)object).getGenericSuperclass();
                }
                if (clazz.isAssignableFrom((Class<?>)object2)) {
                    return GsonTypes.getGenericSupertype(((Class)object).getGenericSuperclass(), object2, clazz);
                }
                object = object2;
            }
        }
        return clazz;
    }

    private static Type getSupertype(Type type, Class<?> clazz, Class<?> clazz2) {
        if (type instanceof WildcardType) {
            Type[] typeArray = ((WildcardType)type).getUpperBounds();
            assert (typeArray.length == 1);
            type = typeArray[0];
        }
        GsonPreconditions.checkArgument(clazz2.isAssignableFrom(clazz));
        return GsonTypes.resolve(type, clazz, GsonTypes.getGenericSupertype(type, clazz, clazz2));
    }

    public static Type getArrayComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
    }

    public static Type getCollectionElementType(Type type, Class<?> clazz) {
        Type type2 = GsonTypes.getSupertype(type, clazz, Collection.class);
        if (type2 instanceof ParameterizedType) {
            return ((ParameterizedType)type2).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    public static Type[] getMapKeyAndValueTypes(Type type, Class<?> clazz) {
        if (Properties.class.isAssignableFrom(clazz)) {
            return new Type[]{String.class, String.class};
        }
        Type type2 = GsonTypes.getSupertype(type, clazz, Map.class);
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            return parameterizedType.getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    public static Type resolve(Type type, Class<?> clazz, Type type2) {
        return GsonTypes.resolve(type, clazz, type2, new HashMap());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static Type resolve(Type var0, Class<?> var1_1, Type var2_2, Map<TypeVariable<?>, Type> var3_3) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            var4_4 = null;
                            while (var2_2 /* !! */  instanceof TypeVariable) {
                                var5_5 = (TypeVariable)var2_2 /* !! */ ;
                                var6_6 /* !! */  = var3_3.get(var5_5);
                                if (var6_6 /* !! */  != null) {
                                    return var6_6 /* !! */  == Void.TYPE ? var2_2 /* !! */  : var6_6 /* !! */ ;
                                }
                                var3_3.put((TypeVariable<?>)var5_5, Void.TYPE);
                                if (var4_4 == null) {
                                    var4_4 = var5_5;
                                }
                                if ((var2_2 /* !! */  = GsonTypes.resolveTypeVariable(var0, var1_1, var5_5)) != var5_5) continue;
                                break block8;
                            }
                            if (!(var2_2 /* !! */  instanceof Class) || !((Class)var2_2 /* !! */ ).isArray()) break block9;
                            var5_5 = var2_2 /* !! */ ;
                            var6_6 /* !! */  = var5_5.getComponentType();
                            var2_2 /* !! */  = GsonTypes.equal(var6_6 /* !! */ , var7_7 = GsonTypes.resolve(var0, var1_1, var6_6 /* !! */ , var3_3)) != false ? var5_5 : GsonTypes.arrayOf(var7_7);
                            break block8;
                        }
                        if (!(var2_2 /* !! */  instanceof GenericArrayType)) break block10;
                        var5_5 = (GenericArrayType)var2_2 /* !! */ ;
                        var6_6 /* !! */  = var5_5.getGenericComponentType();
                        var2_2 /* !! */  = GsonTypes.equal(var6_6 /* !! */ , var7_8 = GsonTypes.resolve(var0, var1_1, var6_6 /* !! */ , var3_3)) != false ? var5_5 : GsonTypes.arrayOf(var7_8);
                        break block8;
                    }
                    if (!(var2_2 /* !! */  instanceof ParameterizedType)) break block11;
                    var5_5 = (ParameterizedType)var2_2 /* !! */ ;
                    var6_6 /* !! */  = var5_5.getOwnerType();
                    var7_9 = GsonTypes.resolve(var0, var1_1, var6_6 /* !! */ , var3_3);
                    var8_11 = GsonTypes.equal(var7_9, var6_6 /* !! */ ) == false;
                    var9_14 = var5_5.getActualTypeArguments();
                    var10_15 = false;
                    var12_17 = var9_14.length;
                    for (var11_16 = 0; var11_16 < var12_17; ++var11_16) {
                        var13_18 = GsonTypes.resolve(var0, var1_1, var9_14[var11_16], var3_3);
                        if (GsonTypes.equal(var13_18, var9_14[var11_16])) continue;
                        if (!var10_15) {
                            var9_14 = (Type[])var9_14.clone();
                            var10_15 = true;
                        }
                        var9_14[var11_16] = var13_18;
                    }
                    var2_2 /* !! */  = var8_11 != false || var10_15 != false ? GsonTypes.newParameterizedTypeWithOwner(var7_9, (Class)var5_5.getRawType(), var9_14) : var5_5;
                    break block8;
                }
                if (!(var2_2 /* !! */  instanceof WildcardType)) break block8;
                var5_5 = (WildcardType)var2_2 /* !! */ ;
                var6_6 /* !! */  = var5_5.getLowerBounds();
                var7_10 = var5_5.getUpperBounds();
                if (var6_6 /* !! */ .length != 1) break block12;
                var8_12 = GsonTypes.resolve(var0, var1_1, var6_6 /* !! */ [0], var3_3);
                if (var8_12 == var6_6 /* !! */ [0]) ** GOTO lbl-1000
                var2_2 /* !! */  = GsonTypes.supertypeOf(var8_12);
                break block8;
            }
            if (var7_10.length == 1 && (var8_13 = GsonTypes.resolve(var0, var1_1, var7_10[0], var3_3)) != var7_10[0]) {
                var2_2 /* !! */  = GsonTypes.subtypeOf(var8_13);
            } else lbl-1000:
            // 2 sources

            {
                var2_2 /* !! */  = var5_5;
            }
        }
        if (var4_4 != null) {
            var3_3.put((TypeVariable<?>)var4_4, var2_2 /* !! */ );
        }
        return var2_2 /* !! */ ;
    }

    private static Type resolveTypeVariable(Type type, Class<?> clazz, TypeVariable<?> typeVariable) {
        Class<?> clazz2 = GsonTypes.declaringClassOf(typeVariable);
        if (clazz2 == null) {
            return typeVariable;
        }
        Type type2 = GsonTypes.getGenericSupertype(type, clazz, clazz2);
        if (type2 instanceof ParameterizedType) {
            int n = GsonTypes.indexOf(clazz2.getTypeParameters(), typeVariable);
            return ((ParameterizedType)type2).getActualTypeArguments()[n];
        }
        return typeVariable;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object obj = typeVariable.getGenericDeclaration();
        return obj instanceof Class ? (Class)obj : null;
    }

    static void checkNotPrimitive(Type type) {
        GsonPreconditions.checkArgument(!(type instanceof Class) || !((Class)type).isPrimitive());
    }

    public static boolean requiresOwnerType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return !Modifier.isStatic(clazz.getModifiers()) && clazz.getDeclaringClass() != null;
        }
        return false;
    }
}

